/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.screen;

import club.sk1er.mods.core.handlers.OnlineIndicator;
import club.sk1er.mods.core.util.Multithreading;
import club.sk1er.patcher.Patcher;
import java.awt.Color;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.kbrewster.mojangapi.MojangAPI;
import me.kbrewster.mojangapi.profile.Name;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class ScreenHistory
extends GuiScreen {
    private final List<String> names = new ArrayList<String>();
    private final boolean focus;
    private GuiTextField nameField;
    private String name;
    private int offset;
    private String exceptionName;

    public ScreenHistory() {
        this("", true);
    }

    public ScreenHistory(String name, boolean focus) {
        this.name = name;
        this.focus = focus;
        this.getNameHistory(name);
    }

    private void getNameHistory(String username) {
        this.offset = 0;
        try {
            if (username.isEmpty()) {
                return;
            }
            Multithreading.runAsync(() -> {
                UUID uuid = null;
                try {
                    uuid = MojangAPI.getUUID((String)username);
                }
                catch (Exception e) {
                    this.exceptionName = e.getClass().getSimpleName();
                    Patcher.instance.getLogger().warn("Failed fetching UUID.", (Throwable)e);
                }
                if (uuid != null) {
                    for (Name history : MojangAPI.getNameHistory((UUID)uuid)) {
                        String name = history.getName();
                        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy");
                        if (history.getChangedToAt() == 0L) {
                            this.names.add(name);
                            continue;
                        }
                        this.names.add(String.format("%s \u00bb %s", name, format.format(history.getChangedToAt())));
                    }
                } else {
                    this.names.add("Failed to fetch " + username + "'s names: " + this.exceptionName);
                }
            });
        }
        catch (Exception e) {
            Patcher.instance.getLogger().warn("User catch failed, tried fetching {}.", new Object[]{username, e});
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.nameField = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 57, this.field_146295_m / 5 + 10, 115, 20);
        this.nameField.func_146180_a(this.name);
        this.nameField.func_146195_b(this.focus);
        this.nameField.func_146203_f(16);
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int left = this.field_146294_l / 3 - 1;
        int top = this.field_146295_m / 5 - 3;
        int right = this.field_146294_l - this.field_146294_l / 3;
        int bottom = this.field_146295_m / 5 + 37;
        this.drawSmoothRect(left, top, right, bottom + this.names.size() * 10 + this.offset, new Color(22, 22, 24).getRGB());
        this.func_73732_a(this.field_146289_q, "Name History", this.field_146294_l / 2, this.field_146295_m / 5, -1);
        this.nameField.func_146194_f();
        for (int currentName = 0; currentName < this.names.size(); ++currentName) {
            float xPos = this.field_146294_l >> 1;
            float yPos = bottom + currentName * 10 + this.offset - 1;
            if (yPos < (float)this.field_146295_m / 5.0f + 35.0f) continue;
            String text = this.names.get(currentName);
            if (currentName == 0) {
                this.func_73732_a(this.field_146289_q, this.exceptionName != null ? text : text + " \u00bb Original", (int)xPos, (int)yPos, new Color(0, 167, 81).getRGB());
                continue;
            }
            this.func_73732_a(this.field_146289_q, text, (int)xPos, (int)yPos, currentName == this.names.size() - 1 ? new Color(1, 162, 82).getRGB() : -1);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.nameField.func_146192_a(mouseX, mouseY, mouseButton);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 28) {
            this.names.clear();
            this.exceptionName = null;
            this.getNameHistory(this.nameField.func_146179_b());
        }
        this.nameField.func_146201_a(typedChar, keyCode);
        this.name = this.nameField.func_146179_b();
        super.func_73869_a(typedChar, keyCode);
    }

    public void func_146281_b() {
        this.names.clear();
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
        this.exceptionName = null;
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int scrollBounds = Mouse.getEventDWheel();
        if (scrollBounds < 0) {
            int size = this.names.size();
            int length = this.field_146295_m / 5 - size * 9;
            if (this.offset - length + 1 > -size && length <= size) {
                this.offset -= 10;
            }
        } else if (scrollBounds > 0 && this.offset < 0) {
            this.offset += 10;
        }
    }

    public void drawSmoothRect(int left, int top, int right, int bottom, int color) {
        int circleSize = 4;
        int radius = 3;
        ScreenHistory.func_73734_a((int)(left += 4), (int)top, (int)(right -= 4), (int)bottom, (int)color);
        ScreenHistory.func_73734_a((int)(left - 4), (int)(top + 3), (int)left, (int)(bottom - 3), (int)color);
        ScreenHistory.func_73734_a((int)right, (int)(top + 3), (int)(right + 4), (int)(bottom - 3), (int)color);
        OnlineIndicator.drawFilledCircle((int)left, (int)(top + 4), (float)4.0f, (int)color);
        OnlineIndicator.drawFilledCircle((int)left, (int)(bottom - 4), (float)4.0f, (int)color);
        OnlineIndicator.drawFilledCircle((int)right, (int)(top + 4), (float)4.0f, (int)color);
        OnlineIndicator.drawFilledCircle((int)right, (int)(bottom - 4), (float)4.0f, (int)color);
    }
}

